package traffic

import (
	"fmt"
	"time"
)

const MAX_DISATNCE_METERS int = 1000
const LANE_COUNT int = 3

// mph
const SPEED_LIMIT = 70

type CarList struct {
	Cars []*Car
}

type Simulation struct {
	CarList    CarList
	MaxCars    int
	Tick       int
	LastUpdate time.Time
}

// func (s Simulation) Run() {
// 	if len(s.Cars) < s.MaxCars {
// 		s.SpawnCar()
// 	}
// }

func (s *Simulation) SpawnCar() {
	personality := GenerateRandomPersonality()
	car := Car{
		Personality:         personality,
		CurrentLane:         personality.GenerateInitialLane(),
		CurrentX:            0,
		Length:              2,
		currentSpeed:        personality.GenerateInitialSpeed(),
		currentAcceleration: 0,
		currentAction:       NORMAL,
		currentTarget:       nil,
	}
	fmt.Printf("Created car!")
	s.CarList = CarList{
		Cars: append(s.CarList.Cars, &car),
	}
}

func (s *Simulation) Update() {
	s.Tick++
	now := time.Now()
	updateSince := now.Sub(s.LastUpdate).Milliseconds()
	// Remove cars
	filtered := s.CarList.Cars[:0]
	for _, car := range s.CarList.Cars {
		if int(car.CurrentX) < MAX_DISATNCE_METERS {
			fmt.Printf("uipdating car")
			car.Update(s, updateSince)
			filtered = append(filtered, car)
		} else {
			fmt.Printf("Removed car")
		}
	}
	s.CarList = CarList{
		Cars: filtered,
	}

	if len(s.CarList.Cars) < s.MaxCars {
		s.SpawnCar()
	}

	s.LastUpdate = now
}

func NewSimulation() *Simulation {
	// var cars []Car
	// for i := 0; i < 10; i++ {
	// 	personality := randomPersonality()
	// 	currentLane := personality.startingLane()
	// 	cars = append(cars, Car{
	// 		Personality: personality,
	// 		CurrentLane: currentLane,
	// 		CurrentSpeed: personality.startingSpeed(),
	// 		CurrentX: generateX(&cars, CurrentLane),
	// 	})
	// }
	sim := &Simulation{
		CarList:    CarList{Cars: []*Car{}},
		MaxCars:    1,
		LastUpdate: time.Now(),
	}

	return sim
}
