package traffic

import (
	"math/rand/v2"
)

const NO_PREFERED_LANE = 4

type Personality struct {
	// Milliseconds
	ResponseTimeAverage float64
	// Percentage of response time variation
	ResponseTimeVariation float64

	// Target gap between car in front (meters)
	TargetGap float64
	MinGap    float64

	// Amount of space between car behind
	// that will be tolerated (meters)
	GapBehindAllowance float64

	// The average acceleration of the person
	// mph/s
	Acceleration float64

	// Max breaking decelleration
	MaxBreakingAcceleration float64

	// Variation in acceleration
	AccelerationVariation float64

	// Amount of distance

	// Fraction of speed limit
	TargetSpeed float64

	// Amount of variation in Target speed
	TargetSpeedVariation float64

	// Chance of switching lane
	LaneSwitchChance float64

	// Chance of checking for traffic when changing lane
	ChangeLaneCheckChance float64

	// Prefered lane
	PreferedLane float64

	// Time in seconds between normal speed checks
	SecondsBetweenSpeedCheck float64
}

var Personalities = []Personality{
	// Average
	{
		ResponseTimeAverage:      750,
		ResponseTimeVariation:    0.5,
		TargetSpeed:              1,
		TargetSpeedVariation:     0.2,
		TargetGap:                30,
		MinGap:                   15,
		GapBehindAllowance:       20,
		Acceleration:             6,
		AccelerationVariation:    0.8,
		MaxBreakingAcceleration:  3,
		LaneSwitchChance:         0.9,
		ChangeLaneCheckChance:    0.9,
		PreferedLane:             NO_PREFERED_LANE,
		SecondsBetweenSpeedCheck: 5,
	},
}

func GenerateRandomPersonality() *Personality {
	return &Personalities[0]
}

func (p *Personality) GenerateInitialLane() int {
	if p.PreferedLane != NO_PREFERED_LANE {
		return int(p.PreferedLane)
	}
	return rand.IntN(LANE_COUNT)
}

func (p *Personality) GenerateInitialSpeed() float64 {
	return SPEED_LIMIT*p.TargetSpeed + (p.TargetSpeed * (rand.Float64() - 0.5) * p.TargetSpeedVariation)
}
