package traffic

import (
	"image/color"

	"github.com/hajimehoshi/ebiten/v2"
	"github.com/hajimehoshi/ebiten/v2/ebitenutil"
)

type Display struct {
	ScreenWidth  int
	ScreenHeight int
	Simulation   *Simulation
}

func (d Display) Init() {
	ebiten.SetWindowSize(d.ScreenWidth, d.ScreenHeight)
	ebiten.SetWindowTitle("Traffic Simulator")
}

func (d Display) Layout(outsideWidth, outsideHeight int) (int, int) {
	return d.ScreenWidth, d.ScreenHeight
}

func (d Display) Update() error {
	d.Simulation.Update()
	return nil
}

func (d Display) CarXToScreenX(carX float64) float64 {
	return (carX / float64(MAX_DISATNCE_METERS)) * float64(d.ScreenWidth)
}

func (d Display) Draw(screen *ebiten.Image) {
	// Draw background
	screen.Fill(color.RGBA{240, 240, 240, 255})

	// Draw hotel box
	roadCenter := d.ScreenHeight / 2
	roadWidth := 60
	ebitenutil.DrawRect(screen, 0, float64(roadCenter-(roadWidth/2)), float64(d.ScreenWidth), float64(roadWidth), color.RGBA{100, 100, 255, 255})

	// Draw guests
	for _, car := range d.Simulation.CarList.Cars {
		col := color.RGBA{255, 100, 100, 255}
		// if guest.checkedIn {
		// 	col = color.RGBA{100, 200, 100, 255}
		// }
		const carSize = 20
		// Move lane count around 0
		topOfLane := float64(roadCenter - (roadWidth / 2))
		ebitenutil.DrawRect(screen, d.CarXToScreenX(car.CurrentX), topOfLane+float64(car.CurrentLane)*(float64(roadWidth)/float64(LANE_COUNT)), d.CarXToScreenX(car.Length), carSize, col)
		// ebitenutil.DrawCircle(screen, (car.CurrentX / float64(MAX_DISATNCE_METERS) * float64(d.ScreenWidth)), float64(car.CurrentLane+carSize), float64(carSize), col)
	}

	// Info
	ebitenutil.DebugPrint(screen, "cars in system: "+string(len(d.Simulation.CarList.Cars)))
}
