package traffic

import (
	"fmt"
	"math/rand/v2"
)

const (
	NORMAL  = 1
	SLOWING = 2
)

type Car struct {
	Personality *Personality
	CurrentLane int
	CurrentX    float64
	Length      float64

	currentSpeed        float64
	currentAcceleration float64
	targetSpeed         float64

	lastSpeedCheck float64

	currentAction int
	currentTarget *Car
}

func (c *Car) GetSpeedEstimate() float64 {
	return c.currentSpeed * rand.Float64()
}

func (c *Car) handleSlowingUpdate(simuation *Simulation, timeDifference int64) {
	// Check if still need to change
	if c.currentTarget == nil {
		c.currentAction = NORMAL
	}
	if c.currentSpeed > c.currentTarget.GetSpeedEstimate() {
		c.currentAcceleration = c.Personality.Acceleration
	}
}

func (c *Car) Update(simuation *Simulation, timeDifference int64) {
	// Check for acceleration changes
	c.lastSpeedCheck += float64(timeDifference) / 1000
	if c.currentAction == NORMAL {
		fmt.Println("Last speed check:", c.lastSpeedCheck)
		if c.lastSpeedCheck >= c.Personality.SecondsBetweenSpeedCheck {
			if c.currentSpeed > c.targetSpeed {
				// If user is over target speed, slow down
				c.currentAcceleration = -(rand.Float64() * c.Personality.AccelerationVariation * c.Personality.MaxBreakingAcceleration)
			} else {
				// Otherwise if underspeed, speed up
				c.currentAcceleration = rand.Float64() * c.Personality.AccelerationVariation * c.Personality.Acceleration
			}
			c.lastSpeedCheck = 0
		}
	} else if c.currentAction == SLOWING {
		c.handleSlowingUpdate(simuation, timeDifference)
	}

	fmt.Println("Current Accelertation: ", c.currentAcceleration)
	c.currentSpeed += (c.currentAcceleration * float64(timeDifference) / 1000)
	fmt.Println("Current Speed: ", c.currentSpeed)
	// Convert current speed fraction to actual speed and then from miles per hour to meters over time frame
	metersPerMillisecond := ((SPEED_LIMIT * c.currentSpeed) / 0.6) / (60 * 60 * 1000)
	println("Time different", timeDifference)
	metersDiff := metersPerMillisecond * float64(timeDifference)

	c.CurrentX += metersDiff
	fmt.Println("New X: ", c.CurrentX)
}
